/*
 * Decompiled with CFR 0.152.
 */
package com.centralnexus;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Locale;
import java.util.jar.Manifest;

public class Utility {
    public static String getJarPath() {
        String fullPath = Utility.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        int startPath = 0;
        if (fullPath.charAt(0) != File.separatorChar) {
            startPath = 1;
        }
        if (!fullPath.endsWith(".jar")) {
            fullPath = fullPath.substring(0, fullPath.lastIndexOf(47));
        }
        fullPath = fullPath.substring(startPath, fullPath.lastIndexOf(47));
        fullPath = fullPath.replace('/', File.separatorChar);
        return fullPath;
    }

    private static Manifest findJarManifest() {
        try {
            URLClassLoader cl = (URLClassLoader)Utility.class.getClassLoader();
            URL url = cl.findResource("META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(url.openStream());
            return manifest;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getJarProperty(String key) {
        Manifest manifest = Utility.findJarManifest();
        if (manifest != null) {
            return manifest.getMainAttributes().getValue(key);
        }
        return null;
    }

    public static String getJarVersion() {
        return Utility.getJarProperty("Implementation-Version");
    }

    public static void addSystemLibDir(String directory) throws IOException {
        try {
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            String[] path = (String[])field.get(null);
            int i = 0;
            while (i < path.length) {
                if (directory.equals(path[i])) {
                    return;
                }
                ++i;
            }
            String[] replacedPath = Arrays.copyOf(path, path.length + 1);
            replacedPath[path.length] = directory;
            field.set(null, replacedPath);
            System.setProperty("java.library.path", String.valueOf(System.getProperty("java.library.path")) + File.pathSeparator + directory);
        }
        catch (IllegalAccessException e) {
            throw new IOException("No permission to set java.library.path");
        }
        catch (NoSuchFieldException e) {
            throw new IOException("Can not get Field for java.library.path");
        }
    }

    public static boolean isCelsiusDefault(Locale locale) {
        String country;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return !(country = locale.getCountry()).equals("US") && !country.equals("BZ") && !country.equals("KY");
    }
}

