/*
 * Decompiled with CFR 0.152.
 */
package com.centralnexus.thermal;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import javax.swing.JPanel;

public class AutoResizeImage
extends JPanel {
    private static final long serialVersionUID = -5440366595142150447L;
    private Image originalImage;
    private Image scaledImage;
    private int originalImageWidth;
    private int originalImageHeight;

    public AutoResizeImage() {
    }

    public AutoResizeImage(Image image) throws IOException {
        this.setIcon(image);
        this.setMinimumSize(new Dimension(1, 1));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.scaledImage != null) {
            this.scaleImage();
            int panelOffsetX = (this.getWidth() - this.scaledImage.getWidth(this)) / 2;
            int panelOffsetY = (this.getHeight() - this.scaledImage.getHeight(this)) / 2;
            g.drawImage(this.scaledImage, panelOffsetX, panelOffsetY, this);
        }
    }

    public void setIcon(Image image) {
        this.originalImage = image;
        this.originalImageWidth = this.originalImage.getWidth(this);
        this.originalImageHeight = this.originalImage.getHeight(this);
        this.setPreferredSize(new Dimension(this.originalImageWidth, this.originalImageHeight));
        this.setMinimumSize(new Dimension(this.originalImageWidth / 2, this.originalImageHeight / 2));
        this.scaleImage();
    }

    public void scaleImage() {
        if (this.originalImage != null) {
            int imageWidth = this.originalImageWidth;
            int imageHeight = this.originalImageHeight;
            int panelWidth = this.getWidth();
            int panelHeight = this.getHeight();
            if (panelWidth < imageWidth || panelHeight < imageHeight) {
                float percentScale = Math.min((float)panelHeight / (float)panelWidth, (float)imageHeight / (float)imageWidth);
                this.scaledImage = this.originalImage.getScaledInstance(Math.max((int)((float)imageWidth * percentScale), 1), Math.max((int)((float)imageHeight * percentScale), 1), 1);
            } else {
                this.scaledImage = this.originalImage;
            }
        }
    }
}

