/*
 * Decompiled with CFR 0.152.
 */
package com.centralnexus.thermal;

import com.centralnexus.thermal.Messages;
import com.centralnexus.thermal.ProgressBar;
import com.centralnexus.thermal.StartMenu;
import com.centralnexus.thermal.WebcamPanel;
import com.lti.civil.CaptureException;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CameraPreviewFrame
extends JComponent {
    private static final long serialVersionUID = 931355892401087251L;
    private StartMenu parent;
    private OutputStream output;
    private SerialPort port;
    private int width;
    private int height;
    private JPanel leftpanel = new JPanel();
    private JLabel calibration = new JLabel();
    private JRadioButton middleselected = new JRadioButton();
    private JRadioButton bottomselected = new JRadioButton();
    private JButton bottomset = new JButton();
    private JButton middleset = new JButton();
    private ButtonGroup buttonGroup1 = new ButtonGroup();
    private ButtonGroup buttonGroup2 = new ButtonGroup();
    private JButton middleup = new JButton();
    private JButton middleleft = new JButton();
    private JButton middleright = new JButton();
    private JButton middledown = new JButton();
    private JLabel resolutionLabel = new JLabel();
    private JRadioButton res1 = new JRadioButton();
    private JRadioButton res3 = new JRadioButton();
    private JButton start = new JButton();
    private WebcamPanel wcamPanel = new WebcamPanel();

    public CameraPreviewFrame(StartMenu parent) {
        this.initComponents();
        this.parent = parent;
    }

    public void run() throws CaptureException {
        try {
            this.endSerial();
            CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier(StartMenu.SETTINGS.getProperty("comPort"));
            this.port = (SerialPort)portId.open("serial talk", 115200);
            this.output = this.port.getOutputStream();
            this.port.setSerialPortParams(115200, 8, 1, 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, Messages.getString("CameraPreviewFrame.ArduinoNotFound", new Object[0]), Messages.getString("Warning", new Object[0]), 2);
            System.err.println("Can not open port " + StartMenu.SETTINGS.getProperty("comPort"));
        }
        this.wcamPanel.run(StartMenu.SETTINGS.getProperty("cameraPort"));
        this.setVisible(true);
    }

    public void send(char command) {
        try {
            if (this.output != null) {
                this.output.write(command);
                this.output.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void endSerial() {
        try {
            if (this.output != null) {
                this.output.close();
                this.output = null;
            }
            if (this.port != null) {
                this.port.close();
                this.port = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void stop() {
        this.endSerial();
        try {
            this.wcamPanel.stopCapture();
        }
        catch (CaptureException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void close() {
        this.endSerial();
        try {
            this.wcamPanel.disposeCapture();
        }
        catch (CaptureException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private void initComponents() {
        Insets defaultInsets;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        GridBagLayout leftGridbag = new GridBagLayout();
        GridBagConstraints leftConstraints = new GridBagConstraints();
        this.leftpanel.setBackground(new Color(255, 255, 255));
        this.leftpanel.setBorder(BorderFactory.createEtchedBorder());
        this.leftpanel.setLayout(leftGridbag);
        leftConstraints.fill = 1;
        leftConstraints.insets = defaultInsets = new Insets(4, 4, 4, 4);
        this.calibration.setFont(new Font("Dialog", 1, 18));
        this.calibration.setText(Messages.getString("CameraPreviewFrame.Calibration", new Object[0]));
        leftConstraints.gridwidth = 0;
        this.leftpanel.add((Component)this.calibration, leftConstraints);
        this.middleselected.setBackground(new Color(255, 255, 255));
        this.buttonGroup1.add(this.middleselected);
        this.middleselected.setFont(new Font("Dialog", 0, 12));
        this.middleselected.setSelected(true);
        this.middleselected.setText(Messages.getString("CameraPreviewFrame.MiddlePoint", new Object[0]));
        this.middleselected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CameraPreviewFrame.this.middleselectedActionPerformed(evt);
            }
        });
        leftConstraints.gridwidth = 1;
        this.leftpanel.add((Component)this.middleselected, leftConstraints);
        this.middleset.setFont(new Font("Dialog", 1, 12));
        this.middleset.setText(Messages.getString("CameraPreviewFrame.Set", new Object[0]));
        this.middleset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CameraPreviewFrame.this.middlesetActionPerformed(evt);
            }
        });
        leftConstraints.gridwidth = 0;
        this.leftpanel.add((Component)this.middleset, leftConstraints);
        this.bottomselected.setBackground(new Color(255, 255, 255));
        this.buttonGroup1.add(this.bottomselected);
        this.bottomselected.setFont(new Font("Dialog", 0, 12));
        this.bottomselected.setText(Messages.getString("CameraPreviewFrame.LeftBottom", new Object[0]));
        this.bottomselected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CameraPreviewFrame.this.bottomselectedActionPerformed(evt);
            }
        });
        leftConstraints.gridwidth = 1;
        this.leftpanel.add((Component)this.bottomselected, leftConstraints);
        this.bottomset.setFont(new Font("Dialog", 1, 12));
        this.bottomset.setText(Messages.getString("CameraPreviewFrame.Set", new Object[0]));
        this.bottomset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CameraPreviewFrame.this.bottomsetActionPerformed(evt);
            }
        });
        leftConstraints.gridwidth = 0;
        this.leftpanel.add((Component)this.bottomset, leftConstraints);
        this.middleup.setText("\u2191");
        this.middleup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CameraPreviewFrame.this.middleupActionPerformed(evt);
            }
        });
        leftConstraints.gridwidth = 0;
        leftConstraints.fill = 0;
        this.leftpanel.add((Component)this.middleup, leftConstraints);
        this.middleleft.setText("\u2190");
        this.middleleft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CameraPreviewFrame.this.middleleftActionPerformed(evt);
            }
        });
        leftConstraints.gridwidth = 1;
        leftConstraints.anchor = 17;
        this.leftpanel.add((Component)this.middleleft, leftConstraints);
        this.middleright.setText("\u2192");
        this.middleright.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CameraPreviewFrame.this.middlerightActionPerformed(evt);
            }
        });
        leftConstraints.gridwidth = 0;
        leftConstraints.anchor = 13;
        this.leftpanel.add((Component)this.middleright, leftConstraints);
        leftConstraints.anchor = 10;
        this.middledown.setText("\u2193");
        this.middledown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CameraPreviewFrame.this.middledownActionPerformed(evt);
            }
        });
        leftConstraints.gridwidth = 0;
        this.leftpanel.add((Component)this.middledown, leftConstraints);
        this.resolutionLabel.setFont(new Font("Dialog", 1, 18));
        this.resolutionLabel.setText(Messages.getString("CameraPreviewFrame.Resoluion", new Object[0]));
        leftConstraints.gridwidth = 0;
        leftConstraints.fill = 1;
        this.leftpanel.add((Component)this.resolutionLabel, leftConstraints);
        this.buttonGroup2.add(this.res1);
        this.res1.setFont(new Font("Dialog", 0, 14));
        this.res1.setSelected(true);
        this.res1.setText(Messages.getString("CameraPreviewFrame.Resolution64x48", new Object[0]));
        this.res1.setBackground(new Color(255, 255, 255));
        leftConstraints.gridwidth = 0;
        leftConstraints.insets = new Insets(0, defaultInsets.left, 0, defaultInsets.left);
        this.leftpanel.add((Component)this.res1, leftConstraints);
        this.buttonGroup2.add(this.res3);
        this.res3.setFont(new Font("Dialog", 0, 14));
        this.res3.setText(Messages.getString("CameraPreviewFrame.Resolution32x24", new Object[0]));
        this.res3.setBackground(new Color(255, 255, 255));
        leftConstraints.gridwidth = 0;
        this.leftpanel.add((Component)this.res3, leftConstraints);
        this.start.setFont(new Font("Dialog", 1, 18));
        this.start.setText(Messages.getString("CameraPreviewFrame.Start", new Object[0]));
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CameraPreviewFrame.this.startActionPerformed(evt);
            }
        });
        leftConstraints.insets = defaultInsets;
        this.leftpanel.add((Component)this.start, leftConstraints);
        this.add((Component)this.leftpanel, c);
        c.gridwidth = 0;
        this.wcamPanel.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout WcamPanelLayout = new GroupLayout(this.wcamPanel);
        this.wcamPanel.setLayout(WcamPanelLayout);
        WcamPanelLayout.setHorizontalGroup(WcamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 636, Short.MAX_VALUE));
        WcamPanelLayout.setVerticalGroup(WcamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 476, Short.MAX_VALUE));
        c.gridwidth = 0;
        c.gridheight = 2;
        this.add((Component)this.wcamPanel, c);
    }

    private void middlerightActionPerformed(ActionEvent evt) {
        if (this.middleselected.isSelected()) {
            this.send('c');
        } else if (this.bottomselected.isSelected()) {
            this.send('h');
        }
    }

    private void middlesetActionPerformed(ActionEvent evt) {
        if (this.middleselected.isSelected()) {
            this.send('f');
        }
    }

    private void bottomsetActionPerformed(ActionEvent evt) {
        if (this.bottomselected.isSelected()) {
            this.send('k');
        }
    }

    private void middledownActionPerformed(ActionEvent evt) {
        if (this.middleselected.isSelected()) {
            this.send('e');
        } else if (this.bottomselected.isSelected()) {
            this.send('j');
        }
    }

    private void middleleftActionPerformed(ActionEvent evt) {
        if (this.middleselected.isSelected()) {
            this.send('b');
        } else if (this.bottomselected.isSelected()) {
            this.send('g');
        }
    }

    private void middleupActionPerformed(ActionEvent evt) {
        if (this.middleselected.isSelected()) {
            this.send('d');
        } else if (this.bottomselected.isSelected()) {
            this.send('i');
        }
    }

    private void startActionPerformed(ActionEvent evt) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmm");
        String date = sdf.format(new Date());
        String dirName = String.valueOf(StartMenu.SETTINGS.getProperty("workingDir")) + this.parent.name + " (" + date + ")";
        File f = new File(dirName);
        if (!f.isDirectory()) {
            f.mkdir();
        }
        try {
            this.wcamPanel.saveImage(dirName);
        }
        catch (CaptureException ex) {
            ex.printStackTrace(System.err);
        }
        if (this.res1.isSelected()) {
            this.width = 64;
            this.height = 48;
        } else if (this.res3.isSelected()) {
            this.width = 32;
            this.height = 24;
        }
        this.endSerial();
        ProgressBar progressbar = new ProgressBar(this.parent);
        progressbar.run(dirName, StartMenu.SETTINGS.getProperty("comPort"), this.parent.name, this.width, this.height);
    }

    private void bottomselectedActionPerformed(ActionEvent evt) {
        this.send('m');
    }

    private void middleselectedActionPerformed(ActionEvent evt) {
        this.send('l');
    }

    public String getCameraID() {
        return this.wcamPanel.getDeviceID();
    }

    public void changeCamera(String deviceID) {
        try {
            this.wcamPanel.disposeCapture();
            this.wcamPanel.run(deviceID);
        }
        catch (CaptureException e) {
            e.printStackTrace(System.err);
        }
    }
}

