/*
 * Decompiled with CFR 0.152.
 */
package com.centralnexus.thermal;

import com.centralnexus.Utility;
import com.centralnexus.thermal.AutoResizeImage;
import com.centralnexus.thermal.Messages;
import com.centralnexus.thermal.StartMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Scanner;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class Output
extends JPanel {
    private static final long serialVersionUID = 6966468502962301998L;
    private static final short SETTINGS_XPADDING = 32;
    private static final short DEFAULT_THERMAL_WIDTH = 640;
    private static final short DEFAULT_THERMAL_HEIGHT = 480;
    private TemperatureStatisticTracker tempTracker = new TemperatureStatisticTracker();
    private boolean mirror = false;
    private float[][] temperatures;
    private boolean[][] showtemp;
    private float max;
    private float average;
    private float min;
    private float tmin;
    private float tmax;
    private float step;
    private int rows;
    private int lines;
    private int broadness;
    private float roomtemp;
    private String name;
    private String dirName;
    private JPanel settingsPanel = new JPanel();
    private JLabel ambienttemp = new JLabel();
    private JLabel ambienttemplabel = new JLabel();
    private JLabel averagetemp = new JLabel();
    private JLabel averagetemplabel = new JLabel();
    private JRadioButton defaultscale = new JRadioButton();
    private JRadioButton alternativescale = new JRadioButton();
    private ButtonGroup scaleTypeGroup = new ButtonGroup();
    private JRadioButton celsiusButton = new JRadioButton();
    private JRadioButton fahrenheitButton = new JRadioButton();
    private ButtonGroup temperatureTypeGroup = new ButtonGroup();
    private JLabel colourscale = new JLabel();
    private JCheckBox complete = new JCheckBox();
    private JSlider maxslider = new JSlider();
    private JLabel maxsliderlabel = new JLabel();
    private JLabel maxtemp = new JLabel();
    private JLabel maxtemplabel = new JLabel();
    private JSlider minslider = new JSlider();
    private JLabel minsliderlabel = new JLabel();
    private JLabel mintemp = new JLabel();
    private JLabel mintemplabel = new JLabel();
    private JLabel mouseovertemp = new JLabel();
    private JLabel mouseovertemplabel = new JLabel();
    private JLabel resolution = new JLabel();
    private JLabel resolutionlabel = new JLabel();
    private JButton save = new JButton();
    private AutoResizeImage thermalimage = new AutoResizeImage();
    private AutoResizeImage webcamimage = new AutoResizeImage();
    private static Color[] DEFAULT_COLOR_SCHEME = new Color[]{new Color(28, 1, 108), new Color(31, 17, 218), new Color(50, 111, 238), new Color(63, 196, 229), new Color(64, 222, 135), new Color(192, 240, 14), new Color(223, 172, 18), new Color(209, 111, 14), new Color(210, 50, 28), new Color(194, 26, 0), new Color(132, 26, 0)};
    private static Color[] ALTERNATE_COLOR_SCHEME = new Color[]{new Color(0, 0, 5), new Color(7, 1, 97), new Color(51, 1, 194), new Color(110, 2, 212), new Color(158, 6, 150), new Color(197, 30, 58), new Color(218, 66, 0), new Color(237, 137, 0), new Color(246, 199, 23), new Color(251, 248, 117), new Color(252, 254, 253)};

    public Output(Window parent) {
        this.initComponents();
        String mirrorStr = (String)StartMenu.SETTINGS.get("mirrorThermalImage");
        this.mirror = mirrorStr == null ? false : mirrorStr.equals("true");
    }

    public void run(String dirName, int rows, int lines) {
        BufferedImage wcamimage;
        this.dirName = dirName;
        this.rows = rows;
        this.lines = lines;
        this.broadness = Math.round(640 / rows);
        this.temperatures = new float[rows][lines];
        this.showtemp = new boolean[rows][lines];
        this.TemperatureData();
        this.LimitValues();
        this.thermalimage.setIcon(this.convertRenderedImage(this.CreateThermalImage()));
        try {
            wcamimage = ImageIO.read(new File(String.valueOf(dirName) + "/Webcam.jpg"));
        }
        catch (Exception ex) {
            System.out.println("Exception : " + ex.getMessage());
            wcamimage = new BufferedImage(640, 480, 1);
        }
        this.webcamimage.setIcon(this.convertRenderedImage(wcamimage));
        this.colourscale.setIcon(new ImageIcon(this.convertRenderedImage(this.createColorScale())));
        this.resolution.setText(String.valueOf(rows) + " x " + lines);
        this.mouseovertemp.setText(Messages.getString("Output.NA", new Object[0]));
        this.formatTemperatureStatistics();
    }

    private void initComponents() {
        MouseTracker mt = new MouseTracker();
        ActionListener scaleTracker = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Output.this.formatTemperatureStatistics();
            }
        };
        GridBagConstraints mainConstraints = new GridBagConstraints();
        GridBagConstraints settingsConstraints = new GridBagConstraints();
        this.setBackground(SystemColor.window);
        this.setLayout(new GridBagLayout());
        this.thermalimage.addMouseMotionListener(mt);
        this.thermalimage.addMouseListener(mt);
        this.thermalimage.setBackground(Color.WHITE);
        this.thermalimage.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.thermalimage.setPreferredSize(new Dimension(640, 480));
        mainConstraints.insets = new Insets(4, 4, 4, 4);
        mainConstraints.fill = 1;
        mainConstraints.weightx = 0.1;
        mainConstraints.weighty = 0.1;
        this.add((Component)this.thermalimage, mainConstraints);
        this.webcamimage.setBackground(Color.WHITE);
        this.webcamimage.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.webcamimage.setPreferredSize(new Dimension(640, 480));
        mainConstraints.gridwidth = 0;
        this.add((Component)this.webcamimage, mainConstraints);
        this.settingsPanel.setBackground(Color.WHITE);
        this.settingsPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.settingsPanel.setLayout(new GridBagLayout());
        Insets defaultInsets = settingsConstraints.insets;
        settingsConstraints.ipadx = 32;
        this.minsliderlabel.setFont(new Font("Dialog", 1, 14));
        this.minsliderlabel.setText(Messages.getString("Output.MinTemp", new Object[0]));
        settingsConstraints.insets = new Insets(8, 0, 0, 0);
        settingsConstraints.anchor = 13;
        this.settingsPanel.add((Component)this.minsliderlabel, settingsConstraints);
        this.minslider.setPaintLabels(true);
        this.minslider.addChangeListener(this.tempTracker);
        this.minslider.setBackground(Color.WHITE);
        settingsConstraints.anchor = 10;
        this.settingsPanel.add((Component)this.minslider, settingsConstraints);
        settingsConstraints.gridwidth = 2;
        this.settingsPanel.add((Component)this.colourscale, settingsConstraints);
        settingsConstraints.gridwidth = 1;
        this.averagetemplabel.setFont(new Font("Dialog", 1, 14));
        this.averagetemplabel.setText(Messages.getString("Output.AverageTemp", new Object[0]));
        settingsConstraints.anchor = 13;
        this.settingsPanel.add((Component)this.averagetemplabel, settingsConstraints);
        this.averagetemp.setFont(new Font("Dialog", 0, 14));
        settingsConstraints.anchor = 17;
        settingsConstraints.ipadx = 0;
        this.settingsPanel.add((Component)this.averagetemp, settingsConstraints);
        settingsConstraints.ipadx = 32;
        this.mouseovertemplabel.setFont(new Font("Dialog", 1, 14));
        this.mouseovertemplabel.setText(Messages.getString("Output.HoverTemp", new Object[0]));
        settingsConstraints.anchor = 13;
        this.settingsPanel.add((Component)this.mouseovertemplabel, settingsConstraints);
        this.mouseovertemp.setFont(new Font("Dialog", 0, 14));
        settingsConstraints.anchor = 17;
        settingsConstraints.ipadx = 0;
        settingsConstraints.gridwidth = 0;
        this.settingsPanel.add((Component)this.mouseovertemp, settingsConstraints);
        settingsConstraints.ipadx = 32;
        settingsConstraints.gridwidth = 1;
        this.maxsliderlabel.setFont(new Font("Dialog", 1, 14));
        this.maxsliderlabel.setText(Messages.getString("Output.MaxTemp", new Object[0]));
        settingsConstraints.insets = defaultInsets;
        settingsConstraints.anchor = 13;
        this.settingsPanel.add((Component)this.maxsliderlabel, settingsConstraints);
        this.maxslider.setBackground(Color.WHITE);
        this.maxslider.setPaintLabels(true);
        this.maxslider.addChangeListener(this.tempTracker);
        this.settingsPanel.add((Component)this.maxslider, settingsConstraints);
        this.defaultscale.setBackground(Color.WHITE);
        this.scaleTypeGroup.add(this.defaultscale);
        this.defaultscale.setFont(new Font("Dialog", 1, 14));
        this.defaultscale.setSelected(true);
        this.defaultscale.setText(Messages.getString("Output.BlueGreenRed", new Object[0]));
        this.defaultscale.addActionListener(this.tempTracker);
        settingsConstraints.anchor = 17;
        this.settingsPanel.add((Component)this.defaultscale, settingsConstraints);
        this.alternativescale.setBackground(Color.WHITE);
        this.scaleTypeGroup.add(this.alternativescale);
        this.alternativescale.setFont(new Font("Dialog", 1, 14));
        this.alternativescale.setText(Messages.getString("Output.RedYellow", new Object[0]));
        this.alternativescale.addActionListener(this.tempTracker);
        settingsConstraints.anchor = 17;
        this.settingsPanel.add((Component)this.alternativescale, settingsConstraints);
        this.maxtemplabel.setFont(new Font("Dialog", 1, 14));
        this.maxtemplabel.setText(Messages.getString("Output.MaxTemp", new Object[0]));
        settingsConstraints.anchor = 13;
        this.settingsPanel.add((Component)this.maxtemplabel, settingsConstraints);
        this.maxtemp.setFont(new Font("Dialog", 0, 14));
        settingsConstraints.anchor = 17;
        this.settingsPanel.add((Component)this.maxtemp, settingsConstraints);
        this.ambienttemplabel.setFont(new Font("Dialog", 1, 14));
        this.ambienttemplabel.setText(Messages.getString("Output.AmbientTemp", new Object[0]));
        settingsConstraints.anchor = 13;
        this.settingsPanel.add((Component)this.ambienttemplabel, settingsConstraints);
        this.ambienttemp.setFont(new Font("Dialog", 0, 14));
        settingsConstraints.gridwidth = 0;
        settingsConstraints.anchor = 17;
        this.settingsPanel.add((Component)this.ambienttemp, settingsConstraints);
        settingsConstraints.gridwidth = 1;
        this.save.setFont(new Font("Dialog", 1, 14));
        this.save.setText(Messages.getString("Output.Save", new Object[0]));
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Output.this.SaveIMG();
            }
        });
        settingsConstraints.insets = new Insets(0, 0, 8, 0);
        settingsConstraints.anchor = 10;
        this.settingsPanel.add((Component)this.save, settingsConstraints);
        this.complete.setBackground(Color.WHITE);
        this.complete.setFont(new Font("Dialog", 1, 14));
        this.complete.setText(Messages.getString("Output.CombinedImage", new Object[0]));
        this.settingsPanel.add((Component)this.complete, settingsConstraints);
        this.celsiusButton.setBackground(Color.WHITE);
        this.temperatureTypeGroup.add(this.celsiusButton);
        this.celsiusButton.setFont(new Font("Dialog", 1, 14));
        this.celsiusButton.setSelected(Utility.isCelsiusDefault(null));
        this.celsiusButton.setText(Messages.getString("Output.Celsius", new Object[0]));
        this.celsiusButton.addActionListener(scaleTracker);
        settingsConstraints.anchor = 17;
        this.settingsPanel.add((Component)this.celsiusButton, settingsConstraints);
        this.fahrenheitButton.setBackground(Color.WHITE);
        this.temperatureTypeGroup.add(this.fahrenheitButton);
        this.fahrenheitButton.setFont(new Font("Dialog", 1, 14));
        this.fahrenheitButton.setSelected(!Utility.isCelsiusDefault(null));
        this.fahrenheitButton.setText(Messages.getString("Output.Fahrenheit", new Object[0]));
        this.fahrenheitButton.addActionListener(scaleTracker);
        settingsConstraints.anchor = 17;
        this.settingsPanel.add((Component)this.fahrenheitButton, settingsConstraints);
        this.mintemplabel.setFont(new Font("Dialog", 1, 14));
        this.mintemplabel.setText(Messages.getString("Output.MinTemp", new Object[0]));
        settingsConstraints.anchor = 13;
        this.settingsPanel.add((Component)this.mintemplabel, settingsConstraints);
        this.mintemp.setFont(new Font("Dialog", 0, 14));
        settingsConstraints.anchor = 17;
        this.settingsPanel.add((Component)this.mintemp, settingsConstraints);
        this.resolutionlabel.setFont(new Font("Dialog", 1, 14));
        this.resolutionlabel.setText(Messages.getString("Output.Resolution", new Object[0]));
        settingsConstraints.anchor = 13;
        this.settingsPanel.add((Component)this.resolutionlabel, settingsConstraints);
        this.resolution.setFont(new Font("Dialog", 0, 14));
        settingsConstraints.anchor = 17;
        this.settingsPanel.add((Component)this.resolution, settingsConstraints);
        mainConstraints.gridwidth = 2;
        mainConstraints.fill = 2;
        mainConstraints.weightx = 1.0;
        mainConstraints.weighty = 1.0;
        this.add((Component)this.settingsPanel, mainConstraints);
        this.validate();
    }

    public void calculateMouseTemp(Point pos) {
        int xpos = (int)pos.getX();
        int ypos = (int)pos.getY();
        int xTempNumber = xpos / this.broadness;
        int yTempNumber = ypos / this.broadness;
        if (xTempNumber < this.rows && yTempNumber < this.lines && xTempNumber >= 0 && yTempNumber >= 0) {
            this.mouseovertemp.setText(this.formatTemperature(this.temperatures[xTempNumber][yTempNumber], true));
        } else {
            this.mouseovertemp.setText(Messages.getString("Output.NA", new Object[0]));
        }
        this.repaint();
    }

    public void showTemp(Point pos) {
        int xpos = (int)pos.getX();
        int ypos = (int)pos.getY();
        int xTempNumber = xpos / this.broadness;
        int yTempNumber = ypos / this.broadness;
        if (xTempNumber < this.rows && yTempNumber < this.lines && xTempNumber >= 0 && yTempNumber >= 0) {
            this.showtemp[xTempNumber][yTempNumber] = !this.showtemp[xTempNumber][yTempNumber];
        }
        this.calculateSlider();
        this.repaint();
    }

    public void LimitValues() {
        this.max = 0.0f;
        this.min = this.temperatures[0][0];
        this.average = 0.0f;
        int x = 0;
        while (x < this.rows) {
            int y = 0;
            while (y < this.lines) {
                if (this.temperatures[x][y] > this.max) {
                    this.max = this.temperatures[x][y];
                }
                if (this.temperatures[x][y] < this.min) {
                    this.min = this.temperatures[x][y];
                }
                this.average += this.temperatures[x][y];
                ++y;
            }
            ++x;
        }
        this.average /= (float)(this.rows * this.lines);
        this.tmax = this.max;
        this.tmin = this.min;
        this.step = (this.max - this.min) / 10.0f;
    }

    public void SaveIMG() {
        BufferedImage img1 = this.convertRenderedImage(this.CreateThermalImage());
        img1 = img1.getSubimage(0, 0, img1.getWidth(), img1.getHeight());
        img1 = img1.getSubimage(0, 0, img1.getWidth(), img1.getHeight());
        BufferedImage img2 = this.convertRenderedImage(this.createColorScale());
        BufferedImage combined = null;
        Graphics g = null;
        if (this.complete.isSelected()) {
            BufferedImage wcamimage = new BufferedImage(640, 480, 1);
            try {
                wcamimage = ImageIO.read(new File(String.valueOf(this.dirName) + "/Webcam.jpg"));
            }
            catch (Exception ex) {
                System.out.println("Exception : " + ex.getMessage());
            }
            combined = new BufferedImage(img1.getWidth() + wcamimage.getWidth() + 30, img1.getHeight() + 80, 1);
            g = combined.getGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, img1.getWidth() + wcamimage.getWidth() + 30, img1.getHeight() + 80);
            g.drawImage(wcamimage, img1.getWidth() + 20, 10, null);
        } else {
            combined = new BufferedImage(img1.getWidth() + 20, img1.getHeight() + 80, 1);
            g = combined.getGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, img1.getWidth() + 20, img1.getHeight() + 80);
        }
        int xadd = (int)Math.round((double)(img1.getWidth() - 550) * 0.5 + 0.5);
        Font font = new Font("Times New Roman", 1, 15);
        g.setFont(font);
        SimpleDateFormat sdf = new SimpleDateFormat();
        g.setColor(Color.darkGray);
        g.drawString(this.name, 218 + xadd, img1.getHeight() + 30);
        g.drawImage(img1, 10, 10, null);
        g.drawImage(img2, xadd - 25, img1.getHeight() + 20, null);
        g.setFont(new Font("Times New Roman", 0, 14));
        g.drawString(sdf.format(new Date()), 480 + xadd, img1.getHeight() + 30);
        g.drawString(String.valueOf(Messages.getString("Output.RoomTempAbbr", new Object[0])) + this.formatTemperature(this.roomtemp, true), 218 + xadd, img1.getHeight() + 55);
        g.drawString(String.valueOf(Messages.getString("Output.MinTempAbbr", new Object[0])) + this.formatTemperature(this.tmin, true), 350 + xadd, img1.getHeight() + 55);
        g.drawString(String.valueOf(Messages.getString("Output.MaxTempAbbr", new Object[0])) + this.formatTemperature(this.tmax, true), 480 + xadd, img1.getHeight() + 55);
        g.dispose();
        try {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File(this.dirName));
            fc.removeChoosableFileFilter(fc.getAcceptAllFileFilter());
            fc.setFileFilter(new JPGfilter());
            fc.setSelectedFile(new File("ThermalImage.jpg"));
            int rVal = fc.showDialog(null, Messages.getString("Output.Save", new Object[0]));
            if (rVal == 0) {
                File file = fc.getSelectedFile();
                ImageIO.write((RenderedImage)combined, "jpg", file);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private static short calculateRGB(int rgb1, int rgb2, double t1, double step, double t) {
        return (short)((double)rgb1 + (t - t1) / step * (double)(rgb2 - rgb1));
    }

    private Color calculateColor(Color[] colorScheme, double temperature) {
        Color val = colorScheme[0];
        if (temperature < (double)this.min) {
            val = colorScheme[0];
        } else if (temperature >= (double)this.max) {
            val = colorScheme[colorScheme.length - 1];
        } else {
            int step1 = (int)((temperature - (double)this.min) / (double)this.step);
            int step2 = step1 + 1;
            Color col1 = colorScheme[step1];
            Color col2 = colorScheme[step2];
            short red = Output.calculateRGB(col1.getRed(), col2.getRed(), this.min + (float)step1 * this.step, this.step, temperature);
            short green = Output.calculateRGB(col1.getGreen(), col2.getGreen(), this.min + (float)step1 * this.step, this.step, temperature);
            short blue = Output.calculateRGB(col1.getBlue(), col2.getBlue(), this.min + (float)step1 * this.step, this.step, temperature);
            val = new Color(red, green, blue);
        }
        return val;
    }

    public RenderedImage CreateThermalImage() {
        int y;
        int xWidthFactor = this.broadness;
        int yWidthFactor = this.broadness;
        BufferedImage bufferedImage = new BufferedImage(640, 480, 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, 640, 480);
        Color[] colorScheme = this.defaultscale.isSelected() ? DEFAULT_COLOR_SCHEME : ALTERNATE_COLOR_SCHEME;
        ArrayList<Float> perimeterVals = new ArrayList<Float>(4);
        int x = 0;
        while (x < this.rows) {
            y = 0;
            while (y < this.lines) {
                g2d.setColor(this.calculateColor(colorScheme, this.temperatures[x][y]));
                g2d.fillRect((int)((double)(x * xWidthFactor) + (double)xWidthFactor * 0.25), (int)((double)(y * yWidthFactor) + (double)yWidthFactor * 0.25), xWidthFactor / 2, yWidthFactor / 2);
                if (y + 1 < this.lines) {
                    g2d.setColor(this.calculateColor(colorScheme, (this.temperatures[x][y] + this.temperatures[x][y + 1]) / 2.0f));
                    g2d.fillRect((int)((double)(x * xWidthFactor) + (double)xWidthFactor * 0.25), (int)((double)(y * yWidthFactor) + (double)yWidthFactor * 0.75), xWidthFactor / 2, yWidthFactor / 2);
                }
                if (x + 1 < this.rows) {
                    g2d.setColor(this.calculateColor(colorScheme, (this.temperatures[x][y] + this.temperatures[x + 1][y]) / 2.0f));
                    g2d.fillRect((int)((double)(x * xWidthFactor) + (double)xWidthFactor * 0.75), (int)((double)(y * yWidthFactor) + (double)yWidthFactor * 0.25), xWidthFactor / 2, yWidthFactor / 2);
                    if (y + 1 < this.lines) {
                        perimeterVals.add(Float.valueOf(this.temperatures[x][y]));
                        perimeterVals.add(Float.valueOf(this.temperatures[x][y + 1]));
                        perimeterVals.add(Float.valueOf(this.temperatures[x + 1][y]));
                        perimeterVals.add(Float.valueOf(this.temperatures[x + 1][y + 1]));
                        Collections.sort(perimeterVals);
                        g2d.setColor(this.calculateColor(colorScheme, (((Float)perimeterVals.get(1)).floatValue() + ((Float)perimeterVals.get(2)).floatValue()) / 2.0f));
                        g2d.fillRect((int)((double)(x * xWidthFactor) + (double)xWidthFactor * 0.75), (int)((double)(y * yWidthFactor) + (double)yWidthFactor * 0.75), xWidthFactor / 2, yWidthFactor / 2);
                    }
                }
                perimeterVals.clear();
                ++y;
            }
            ++x;
        }
        g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g2d.setFont(new Font("Arial", 1, 15));
        x = 0;
        while (x < this.rows) {
            y = 0;
            while (y < this.lines) {
                if (this.showtemp[x][y]) {
                    int ix = x * xWidthFactor;
                    int iy = y * yWidthFactor;
                    g2d.setColor(Color.black);
                    String tempStr = this.formatTemperature(this.temperatures[x][y], true);
                    g2d.fillOval(ix + (int)((double)xWidthFactor * 0.25), iy + (int)((double)yWidthFactor * 0.25), (int)Math.round((double)xWidthFactor * 0.5), (int)Math.round((double)yWidthFactor * 0.5));
                    Rectangle2D textBounds = g2d.getFontMetrics().getStringBounds(tempStr, g2d);
                    int strOffsetX = ix - (int)(textBounds.getWidth() / 2.0 - (double)(this.broadness / 2));
                    int strOffsetY = iy + (int)textBounds.getHeight() + this.broadness / 2;
                    if (strOffsetX < 0) {
                        strOffsetX = 0;
                    }
                    if ((double)strOffsetX + textBounds.getWidth() > (double)this.thermalimage.getWidth()) {
                        strOffsetX = this.thermalimage.getWidth() - (int)textBounds.getWidth();
                    }
                    if ((double)strOffsetY + textBounds.getHeight() > (double)this.thermalimage.getHeight()) {
                        strOffsetY = iy;
                    }
                    g2d.drawString(tempStr, strOffsetX, strOffsetY);
                }
                ++y;
            }
            ++x;
        }
        g2d.dispose();
        return bufferedImage;
    }

    public RenderedImage createColorScale() {
        BufferedImage bufferedImage = new BufferedImage(230, 32, 1);
        try {
            if (this.defaultscale.isSelected()) {
                bufferedImage = ImageIO.read(this.getClass().getResource("Colorscale1.png"));
            } else if (this.alternativescale.isSelected()) {
                bufferedImage = ImageIO.read(this.getClass().getResource("Colorscale2.png"));
            }
        }
        catch (Exception ex) {
            System.out.println("Exception : " + ex.getMessage());
        }
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g2d.setFont(new Font("Arial", 1, 12));
        g2d.setColor(Color.black);
        g2d.drawString(this.formatTemperature(this.min, false), 3, 30);
        g2d.drawString(this.formatTemperature(this.min + this.step, false), 26, 30);
        g2d.drawString(this.formatTemperature(this.min + 2.0f * this.step, false), 49, 30);
        g2d.drawString(this.formatTemperature(this.min + 3.0f * this.step, false), 72, 30);
        g2d.drawString(this.formatTemperature(this.min + 4.0f * this.step, false), 95, 30);
        g2d.drawString(this.formatTemperature(this.min + 5.0f * this.step, false), 118, 30);
        g2d.drawString(this.formatTemperature(this.min + 6.0f * this.step, false), 141, 30);
        g2d.drawString(this.formatTemperature(this.min + 7.0f * this.step, false), 164, 30);
        g2d.drawString(this.formatTemperature(this.min + 8.0f * this.step, false), 187, 30);
        g2d.drawString(this.formatTemperature(this.max, false), 212, 30);
        g2d.dispose();
        return bufferedImage;
    }

    public void TemperatureData() {
        try {
            Scanner scanner = new Scanner(new File(String.valueOf(this.dirName) + "/tempvalues.txt"));
            scanner.useLocale(Locale.US);
            int i = 0;
            int values = this.rows * this.lines;
            if (this.mirror) {
                int x = 0;
                while (x < this.rows) {
                    int y = this.lines - 1;
                    while (y >= 0) {
                        if (scanner.hasNextFloat() && i <= values) {
                            this.temperatures[x][y] = scanner.nextFloat();
                            ++i;
                        }
                        --y;
                    }
                    ++x;
                }
            } else {
                int x = this.rows - 1;
                while (x >= 0) {
                    int y = this.lines - 1;
                    while (y >= 0) {
                        if (scanner.hasNextFloat() && i <= values) {
                            this.temperatures[x][y] = scanner.nextFloat();
                            ++i;
                        }
                        --y;
                    }
                    --x;
                }
            }
            this.roomtemp = scanner.nextFloat();
            this.name = scanner.next();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(null, Messages.getString("WebcamPanel.ErrorReadingTemperatureFile", new Object[0]), Messages.getString("Error", new Object[0]), 0);
            return;
        }
    }

    public BufferedImage convertRenderedImage(RenderedImage img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        ColorModel cm = img.getColorModel();
        int width = img.getWidth();
        int height = img.getHeight();
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] keys = img.getPropertyNames();
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                properties.put(keys[i], img.getProperty(keys[i]));
                ++i;
            }
        }
        BufferedImage result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
        img.copyData(raster);
        return result;
    }

    private void formatTemperatureStatistics() {
        this.tempTracker.setEnabled(false);
        this.ambienttemp.setText(this.formatTemperature(this.roomtemp, true));
        this.averagetemp.setText(this.formatTemperature(this.average, true));
        this.mintemp.setText(this.formatTemperature(this.tmin, true));
        this.maxtemp.setText(this.formatTemperature(this.tmax, true));
        float middletemp = this.roomtemp > this.tmin && this.roomtemp < this.tmax ? this.roomtemp : (float)Math.round((double)this.tmin + (double)(this.tmax - this.tmin) * 0.5);
        int maxVal = Math.round(this.convertToCurrentTemperatureType(this.tmax + 25.0f));
        int minVal = Math.round(this.convertToCurrentTemperatureType(middletemp + 1.0f));
        int val = Math.round(this.convertToCurrentTemperatureType(this.tmax));
        int bigspace = (int)((double)(maxVal - minVal) * 0.2);
        int smallspace = (int)(0.5 * (double)bigspace);
        this.maxslider.setMinimum(val - smallspace);
        this.maxslider.setMaximum(val + bigspace * 4);
        this.maxslider.setValue(val);
        this.maxslider.setMinorTickSpacing(smallspace);
        this.maxslider.setMajorTickSpacing(bigspace);
        maxVal = Math.round(this.convertToCurrentTemperatureType(middletemp - 1.0f));
        minVal = Math.round(this.convertToCurrentTemperatureType(this.tmin - 25.0f));
        val = Math.round(this.convertToCurrentTemperatureType(this.tmin));
        this.minslider.setMinimum(minVal);
        this.minslider.setMaximum(maxVal);
        this.minslider.setValue(val);
        bigspace = (int)((double)(maxVal - minVal) * 0.2);
        smallspace = (int)(0.5 * (double)bigspace);
        this.minslider.setMinimum(val - bigspace * 4);
        this.minslider.setMaximum(val + smallspace);
        this.minslider.setValue(val);
        this.minslider.setMinorTickSpacing(smallspace);
        this.minslider.setMajorTickSpacing(bigspace);
        this.tempTracker.setEnabled(true);
        this.calculateSlider();
    }

    public void calculateSlider() {
        this.max = this.convertFromCurrentTemperatureType(this.maxslider.getValue());
        this.min = this.convertFromCurrentTemperatureType(this.minslider.getValue());
        this.step = (this.max - this.min) / 10.0f;
        this.colourscale.setIcon(new ImageIcon(this.convertRenderedImage(this.createColorScale())));
        this.thermalimage.setIcon(this.convertRenderedImage(this.CreateThermalImage()));
        this.thermalimage.repaint();
    }

    private String formatTemperature(float val, boolean showLongFormat) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        String format = showLongFormat ? "%1$.2f\u00b0%2$s" : "%1$.0f\u00b0";
        if (this.celsiusButton.isSelected()) {
            formatter.format(format, Float.valueOf(val), showLongFormat ? Messages.getString("Output.CelsiusAbbr", new Object[0]) : "");
        } else {
            formatter.format(format, Float.valueOf(Output.convertToFahrenheit(val)), showLongFormat ? Messages.getString("Output.FahrenheitAbbr", new Object[0]) : "");
        }
        return sb.toString();
    }

    private static float convertToFahrenheit(float val) {
        return val * 9.0f / 5.0f + 32.0f;
    }

    private static float convertFromFahrenheit(float val) {
        return (val - 32.0f) * 5.0f / 9.0f;
    }

    private float convertToCurrentTemperatureType(float val) {
        if (this.celsiusButton.isSelected()) {
            return val;
        }
        return Output.convertToFahrenheit(val);
    }

    private float convertFromCurrentTemperatureType(float val) {
        if (this.celsiusButton.isSelected()) {
            return val;
        }
        return Output.convertFromFahrenheit(val);
    }

    public class JPGfilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase().endsWith(".jpg") || f.getName().toLowerCase().endsWith(".jpeg");
        }

        @Override
        public String getDescription() {
            return Messages.getString("Output.JpegTypeInfo", new Object[0]);
        }
    }

    private class MouseTracker
    implements MouseListener,
    MouseMotionListener {
        private MouseTracker() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Output.this.calculateMouseTemp(e.getPoint());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                Output.this.showTemp(e.getPoint());
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Output.this.mouseovertemp.setText(Messages.getString("Output.NA", new Object[0]));
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }
    }

    private class TemperatureStatisticTracker
    implements ChangeListener,
    ActionListener {
        boolean enableTracking = true;

        private TemperatureStatisticTracker() {
        }

        @Override
        public synchronized void stateChanged(ChangeEvent arg0) {
            if (this.enableTracking) {
                Output.this.calculateSlider();
            }
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            if (this.enableTracking) {
                Output.this.calculateSlider();
            }
        }

        public synchronized void setEnabled(boolean val) {
            this.enableTracking = val;
        }
    }
}

