/*
 * Decompiled with CFR 0.152.
 */
package com.centralnexus.thermal;

import com.centralnexus.thermal.Messages;
import com.centralnexus.thermal.StartMenu;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressBar
extends JDialog
implements SerialPortEventListener {
    private static final long serialVersionUID = 357793947402536140L;
    private String dirName;
    private String name;
    private String comport;
    private float[] tempvalues;
    private String[] strinput = new String[1];
    private int roomtemp = 0;
    private boolean[] checktemp;
    private int values;
    private int count;
    private int rows;
    private int lines;
    private long startTime;
    private SerialPort port;
    private File out;
    private PrintWriter pw;
    private InputStream input;
    private OutputStream output;
    private StartMenu parent;
    private static final double PIXELS_PER_SECOND = 7.45;
    private JProgressBar current;
    private JLabel remainingtime;
    private JLabel status;

    public ProgressBar(StartMenu parent) {
        super(parent);
        this.parent = parent;
        this.initComponents();
    }

    public void run(String dirName, String comport, String name, int rows, int lines) {
        this.dirName = dirName;
        this.comport = comport;
        this.name = name;
        this.rows = rows;
        this.lines = lines;
        File f = new File(dirName);
        if (!f.isDirectory()) {
            f.mkdir();
        }
        this.values = rows * lines;
        this.strinput = new String[(int)Math.round((double)this.values * 1.2)];
        this.current.setMaximum((int)Math.round((double)this.values + 3.0));
        this.tempvalues = new float[this.values];
        this.checktemp = new boolean[this.values];
        this.updateTimeStatus();
        this.startTime = System.currentTimeMillis();
        try {
            CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier(comport);
            this.port = (SerialPort)portId.open("serial talk", 115200);
            this.input = this.port.getInputStream();
            this.output = this.port.getOutputStream();
            this.port.setSerialPortParams(115200, 8, 1, 0);
            this.port.addEventListener(this);
            this.port.notifyOnDataAvailable(true);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this.parent, Messages.getString("ProgressBar.NotConnected", new Object[0]), Messages.getString("Error", new Object[0]), 0);
            return;
        }
        try {
            Thread.sleep(1500L);
            if (this.values == 3072) {
                this.send('n');
            }
            if (this.values == 1728) {
                this.send('o');
            }
            if (this.values == 768) {
                this.send('p');
            }
            if (this.values == 192) {
                this.send('q');
            }
            this.output.write(97);
            this.output.flush();
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void send(char command) throws IOException, InterruptedException {
        this.output.write(command);
        this.output.flush();
    }

    public synchronized void close() throws IOException, InterruptedException {
        if (this.output != null) {
            this.send('~');
            this.output.close();
            this.output = null;
        }
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
        if (this.port != null) {
            this.port.close();
            this.port = null;
        }
    }

    @Override
    public synchronized void serialEvent(SerialPortEvent oEvent) {
        if (oEvent.getEventType() == 1) {
            try {
                do {
                    char inChar;
                    StringBuilder strbuilder = new StringBuilder();
                    while ((inChar = (char)this.input.read()) != '\n') {
                        strbuilder.append(inChar);
                    }
                    String incoming = strbuilder.toString().trim();
                    if (incoming.charAt(0) == 'r') {
                        this.roomtemp = Integer.parseInt(incoming.substring(1));
                        continue;
                    }
                    if (incoming.startsWith("Stop")) {
                        this.finish();
                        continue;
                    }
                    this.strinput[this.count] = incoming;
                    ++this.count;
                    this.current.setValue(this.count);
                    this.updateTimeStatus();
                } while (this.input.available() > 0);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private void updateTimeStatus() {
        int time = (int)Math.round((double)(this.values - this.count) / 7.45);
        if (time >= 0) {
            this.status.setText(String.valueOf(time / 60) + ":" + (time % 60 < 10 ? "0" : "") + time % 60);
        }
    }

    public void finish() {
        this.stringhandling();
        try {
            this.out = new File(String.valueOf(this.dirName) + "/tempvalues.txt");
            this.pw = new PrintWriter(new FileWriter(this.out.getPath(), true));
            this.pw.flush();
            int i = 0;
            while (i < this.values) {
                if (!this.checktemp[i]) {
                    if (i > 0) {
                        this.tempvalues[i] = this.tempvalues[i - 1];
                        System.err.println(i);
                    } else {
                        this.tempvalues[i] = 0.0f;
                        System.err.println(i);
                    }
                }
                this.pw.println(this.tempvalues[i]);
                ++i;
            }
            this.pw.println(this.roomtemp);
            this.pw.println(this.name);
            this.pw.println("r" + this.rows);
            this.pw.println("l" + this.lines);
            this.pw.flush();
            this.pw.close();
            this.setVisible(false);
            this.parent.displayProject(this.dirName, this.rows, this.lines);
            long endTime = System.currentTimeMillis();
            System.out.println("Elapsed time=" + (endTime - this.startTime) / 1000L + " seconds");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void stringhandling() {
        float temp = 0.0f;
        int number = 0;
        Pattern splitPattern = Pattern.compile("\t");
        String errorStr = "";
        int i = 0;
        while (i < this.count) {
            if (this.strinput[i] != null) {
                try {
                    String[] strVals = splitPattern.split(this.strinput[i]);
                    number = Integer.parseInt(strVals[0]);
                    temp = Float.parseFloat(strVals[1]);
                    if (number <= this.values && number >= 1) {
                        this.tempvalues[number - 1] = temp;
                        this.checktemp[number - 1] = true;
                    }
                }
                catch (Exception e) {
                    errorStr = String.valueOf(errorStr) + this.strinput[i] + '\n';
                    System.out.println("Failed to parse at index " + i + ": " + this.strinput[i]);
                    e.printStackTrace(System.err);
                }
            }
            ++i;
        }
        if (errorStr.length() > 0) {
            JOptionPane.showMessageDialog(this.parent, String.valueOf(Messages.getString("ProgressBar.ParseError", new Object[0])) + '\n' + errorStr, Messages.getString("Error", new Object[0]), 0);
        }
    }

    private void initComponents() {
        this.current = new JProgressBar();
        this.remainingtime = new JLabel();
        this.status = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(Messages.getString("ProgressBar.Title", new Object[0]));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProgressBar.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.current.setBackground(new Color(255, 255, 255));
        this.current.setForeground(new Color(51, 204, 255));
        this.current.setMaximumSize(new Dimension(220, 29));
        this.current.setMinimumSize(new Dimension(220, 29));
        this.current.setPreferredSize(new Dimension(220, 29));
        this.current.setStringPainted(true);
        this.getContentPane().add((Component)this.current, "Center");
        JPanel remainingPanel = new JPanel();
        this.remainingtime.setFont(new Font("SansSerif", 1, 14));
        this.remainingtime.setText(Messages.getString("ProgressBar.RemainingTime", new Object[0]));
        remainingPanel.add(this.remainingtime);
        this.status.setFont(new Font("SansSerif", 0, 14));
        remainingPanel.add(this.status);
        this.add((Component)remainingPanel, "South");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 256) / 2, (screenSize.height - 116) / 2, this.getSize().width, this.getSize().height);
    }

    private void formWindowClosing(WindowEvent evt) {
        try {
            this.close();
            try {
                CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier(this.comport);
                this.port = (SerialPort)portId.open("serial talk", 115200);
                this.port.setSerialPortParams(115200, 8, 1, 0);
            }
            catch (NoSuchPortException ex) {
                ex.printStackTrace(System.err);
            }
            catch (PortInUseException ex) {
                ex.printStackTrace(System.err);
            }
            catch (UnsupportedCommOperationException ex) {
                ex.printStackTrace(System.err);
            }
            Thread.sleep(1000L);
            this.close();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace(System.err);
        }
    }
}

