/*
 * Decompiled with CFR 0.152.
 */
package com.centralnexus.thermal;

import com.centralnexus.Utility;
import com.centralnexus.thermal.CameraPreviewFrame;
import com.centralnexus.thermal.Messages;
import com.centralnexus.thermal.Output;
import com.centralnexus.thermal.WebcamPanel;
import com.lti.civil.CaptureDeviceInfo;
import com.lti.civil.CaptureException;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;

public class StartMenu
extends JFrame {
    private static final long serialVersionUID = 4138804478889721326L;
    public static final String PROGRAM_NAME = "Thermal Imager";
    public static final String LICENSE = "http://www.centralnexus.com/\n\u00a9 2011-2013 George Rhoten\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the \"Software\"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in\nall copies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\nTHE SOFTWARE.\n\nAuthors: George Rhoten, Max Ritter\nVersion: ";
    public static final String WORKING_DIRECTORY = "workingDir";
    public static final String COM_PORT = "comPort";
    public static final String CAMERA_PORT = "cameraPort";
    public static final String DEFAULT_PROJECT_NAME = "defaultProjectName";
    public static final String MIRROR_IMAGE = "mirrorThermalImage";
    private static final String CONFIG_FILE = "configuration.txt";
    private static final String[] PORT_NAMES = new String[]{"COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "/dev/tty.usbserial-A6008lIf", "/dev/tty.usbserial-A9007UX1", "/dev/ttyUSB0", "/dev/ttyUSB1", "/dev/ttyACM0"};
    private Vector<String> availablePorts = new Vector();
    String name = "Thermal";
    private String comPort = PORT_NAMES[0];
    private String cameraPort = null;
    static Properties SETTINGS = new Properties();
    private JMenuBar menuBar = new JMenuBar();
    private ButtonGroup buttonGroupCOM = new ButtonGroup();
    private ButtonGroup buttonGroupCamera = new ButtonGroup();
    private CameraPreviewFrame cameraPanel;
    private JComponent mainComponent;
    private JMenu cameraMenu;

    StartMenu() {
        this.findCOMPorts();
        this.loadConfig();
        this.initComponents();
        this.findCameraPorts();
        File f = new File(SETTINGS.getProperty(WORKING_DIRECTORY));
        if (!f.isDirectory()) {
            f.mkdir();
        }
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.setBackground(new Color(255, 255, 255));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                StartMenu.this.formWindowClosing(evt);
            }
        });
        GridBagLayout gridbag = new GridBagLayout();
        this.getContentPane().setLayout(gridbag);
        JMenu menu = new JMenu(Messages.getString("StartMenu.File", new Object[0]));
        this.menuBar.add(menu);
        JMenuItem mItem = new JMenuItem(Messages.getString("StartMenu.Open", new Object[0]));
        mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartMenu.this.openWorkFolderActionPerformed();
            }
        });
        menu.add(mItem);
        mItem = new JMenuItem(Messages.getString("StartMenu.Capture", new Object[0]));
        mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartMenu.this.displayCapture();
            }
        });
        menu.add(mItem);
        menu = new JMenu(Messages.getString("StartMenu.Settings", new Object[0]));
        this.menuBar.add(menu);
        mItem = new JMenuItem(Messages.getString("StartMenu.WorkFolder", new Object[0]));
        mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartMenu.this.workfolderActionPerformed();
            }
        });
        menu.add(mItem);
        mItem = new JMenuItem(Messages.getString("StartMenu.ProjectName", new Object[0]));
        mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartMenu.this.projectnameActionPerformed();
            }
        });
        menu.add(mItem);
        JMenu portMenu = new JMenu(Messages.getString("StartMenu.Port", new Object[0]));
        menu.add(portMenu);
        for (String port : this.availablePorts) {
            mItem = new JRadioButtonMenuItem(port, this.comPort.equals(port));
            mItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JRadioButtonMenuItem source = (JRadioButtonMenuItem)evt.getSource();
                    StartMenu.this.comPort = source.getText();
                    SETTINGS.setProperty(StartMenu.COM_PORT, StartMenu.this.comPort);
                    StartMenu.this.saveConfig();
                    StartMenu.this.displayCapture();
                }
            });
            portMenu.add(mItem);
            this.buttonGroupCOM.add(mItem);
        }
        if (this.availablePorts.size() == 0) {
            portMenu.setEnabled(false);
        }
        this.cameraMenu = new JMenu(Messages.getString("StartMenu.Camera", new Object[0]));
        menu.add(this.cameraMenu);
        this.cameraMenu.setEnabled(false);
        menu = new JMenu(Messages.getString("StartMenu.Help", new Object[0]));
        this.menuBar.add(menu);
        mItem = new JMenuItem(Messages.getString("StartMenu.About", new Object[0]));
        mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JOptionPane.showMessageDialog(null, StartMenu.LICENSE + Utility.getJarProperty("Implementation-Version"), Messages.getString("StartMenu.About", new Object[0]), -1);
            }
        });
        menu.add(mItem);
        this.setJMenuBar(this.menuBar);
        this.cameraPanel = new CameraPreviewFrame(this);
        this.displayCapture();
        try {
            this.setIconImage(ImageIO.read(this.getClass().getResource("Thermal.png")));
        }
        catch (IOException port) {
            // empty catch block
        }
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 876) / 2, (screenSize.height - 577) / 2, this.getSize().width, this.getSize().height);
    }

    private void saveConfig() {
        File out = new File(CONFIG_FILE);
        if (out.exists()) {
            out.delete();
        }
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(out.getPath(), true));
            SETTINGS.store(pw, "");
            pw.close();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private void setDefaultProperty(String key, String value) {
        if (SETTINGS.getProperty(key) == null) {
            SETTINGS.setProperty(key, value);
        }
    }

    private void loadConfig() {
        try {
            File f = new File(CONFIG_FILE);
            if (f.isFile()) {
                FileReader fr = new FileReader(f);
                SETTINGS.load(fr);
                fr.close();
            }
            if (SETTINGS.size() < 5) {
                this.setDefaultProperty(WORKING_DIRECTORY, String.valueOf(new File(".").getCanonicalPath()) + File.separator);
                this.setDefaultProperty(COM_PORT, this.comPort);
                this.setDefaultProperty(CAMERA_PORT, this.cameraPort == null ? "" : this.cameraPort);
                this.setDefaultProperty(DEFAULT_PROJECT_NAME, "Thermal");
                this.setDefaultProperty(MIRROR_IMAGE, "false");
                this.saveConfig();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        this.comPort = SETTINGS.getProperty(COM_PORT);
        this.cameraPort = SETTINGS.getProperty(CAMERA_PORT);
    }

    private void findCOMPorts() {
        PrintStream cachePS = System.out;
        System.setOut(new PrintStream(new ByteArrayOutputStream()));
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        System.setOut(cachePS);
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier currPortId = (CommPortIdentifier)portEnum.nextElement();
            this.availablePorts.add(currPortId.getName());
        }
        String[] stringArray = PORT_NAMES;
        int n = PORT_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String portName = stringArray[n2];
            try {
                CommPortIdentifier.getPortIdentifier(portName);
                if (!this.availablePorts.contains(portName)) {
                    this.availablePorts.add(portName);
                }
            }
            catch (NoSuchPortException noSuchPortException) {
                // empty catch block
            }
            ++n2;
        }
        if (this.availablePorts.size() > 0 && this.comPort == PORT_NAMES[0]) {
            this.comPort = this.availablePorts.get(0);
        }
    }

    private void findCameraPorts() {
        if (this.cameraPort == null || this.cameraPort.length() == 0) {
            this.cameraPort = this.cameraPanel.getCameraID();
            SETTINGS.setProperty(CAMERA_PORT, this.cameraPort);
            this.saveConfig();
        }
        List<CaptureDeviceInfo> cameraPorts = WebcamPanel.getCaptureList();
        for (CaptureDeviceInfo port : cameraPorts) {
            JRadioButtonMenuItem mItem = new JRadioButtonMenuItem(port.getDeviceID(), this.cameraPort != null && this.cameraPort.equals(port.getDeviceID()));
            mItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JRadioButtonMenuItem source = (JRadioButtonMenuItem)evt.getSource();
                    StartMenu.this.cameraPort = source.getText();
                    SETTINGS.setProperty(StartMenu.CAMERA_PORT, StartMenu.this.cameraPort);
                    StartMenu.this.saveConfig();
                    if (!StartMenu.this.cameraPort.equals(StartMenu.this.cameraPanel.getCameraID())) {
                        StartMenu.this.cameraPanel.changeCamera(StartMenu.this.cameraPort);
                    }
                }
            });
            this.cameraMenu.add(mItem);
            this.buttonGroupCamera.add(mItem);
        }
        this.cameraMenu.setEnabled(cameraPorts.size() != 0);
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.cameraPanel != null) {
            this.cameraPanel.close();
        }
    }

    private void openWorkFolderActionPerformed() {
        JFileChooser fc = new JFileChooser(SETTINGS.getProperty(WORKING_DIRECTORY));
        fc.setDialogTitle(Messages.getString("StartMenu.ChooseProjectDirectory", new Object[0]));
        fc.setFileSelectionMode(1);
        int rVal = fc.showOpenDialog(null);
        if (rVal == 0) {
            String dirName = fc.getSelectedFile().getPath();
            File dataContent = new File(String.valueOf(dirName) + "/tempvalues.txt");
            if (dataContent.exists() && new File(String.valueOf(dirName) + "/Webcam.jpg").exists()) {
                int width = 0;
                int height = 0;
                try {
                    Scanner scanner = new Scanner(dataContent);
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        if (line.startsWith("r")) {
                            line = line.replace('r', '0');
                            width = Integer.parseInt(line);
                        }
                        if (!line.startsWith("l")) continue;
                        line = line.replace('l', '0');
                        height = Integer.parseInt(line);
                    }
                }
                catch (IOException e) {
                    System.out.println(e);
                }
                if (width != 0 && height != 0) {
                    this.displayProject(dirName, width, height);
                }
            } else {
                JOptionPane.showMessageDialog(this, Messages.getString("StartMenu.MissingProjectFile", new Object[0]), Messages.getString("Error", new Object[0]), 0);
            }
        }
    }

    void resetSubPanels() {
        if (this.mainComponent != null) {
            this.remove(this.mainComponent);
        }
    }

    void displayProject(String dirName, int width, int height) {
        this.resetSubPanels();
        this.cameraPanel.stop();
        Output outputnew = new Output(this);
        outputnew.run(dirName, width, height);
        this.add(outputnew);
        this.setTitle(Messages.getString("StartMenu.OutputDirectoryTitle", PROGRAM_NAME, dirName));
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = this.getSize();
        this.setBounds((screenSize.width - windowSize.width) / 2, (screenSize.height - windowSize.height) / 2, windowSize.width, windowSize.height);
        this.mainComponent = outputnew;
    }

    void displayCapture() {
        this.resetSubPanels();
        this.mainComponent = this.cameraPanel;
        try {
            this.cameraPanel.run();
        }
        catch (CaptureException ex) {
            ex.printStackTrace(System.err);
        }
        this.add(this.cameraPanel);
        this.pack();
        this.setTitle(Messages.getString("StartMenu.TitlePreview", PROGRAM_NAME));
    }

    private void workfolderActionPerformed() {
        JFileChooser fc = new JFileChooser(SETTINGS.getProperty(WORKING_DIRECTORY));
        fc.setDialogTitle(Messages.getString("StartMenu.ChooseWorkingDirectory", new Object[0]));
        fc.setFileSelectionMode(1);
        int rVal = fc.showOpenDialog(null);
        if (rVal == 0) {
            SETTINGS.setProperty(WORKING_DIRECTORY, fc.getSelectedFile() + File.separator);
            this.saveConfig();
        }
    }

    private void projectnameActionPerformed() {
        String returnedName = JOptionPane.showInputDialog(this, Messages.getString("StartMenu.NewProjectName", new Object[0]), this.name);
        if (returnedName != null) {
            this.name = returnedName;
        }
    }

    public static void main(String[] args) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        String libpath = null;
        if (os.indexOf("win") >= 0) {
            if (arch.equals("x86")) {
                libpath = "lib/win32-x86";
            } else if (arch.equals("amd64")) {
                libpath = "lib/win32-x86_64";
            }
        } else if (os.indexOf("mac") >= 0) {
            if (arch.equals("i386")) {
                libpath = "lib/macosx-universal";
            } else {
                JOptionPane.showMessageDialog(null, Messages.getString("StartMenu.UnsupportedX64", new Object[0]), Messages.getString("Error", new Object[0]), 0);
                System.exit(1);
            }
        } else if (os.indexOf("lin") >= 0) {
            if (arch.equals("x86")) {
                libpath = "lib/linux-x86";
            } else if (arch.equals("amd64")) {
                libpath = "lib/linux-x86_64";
            }
        }
        if (libpath == null) {
            System.out.println("Warning: " + os + "/" + arch + " is an unrecognized platform.");
        } else {
            System.setProperty("java.library.path", libpath);
        }
        Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
        fieldSysPath.setAccessible(true);
        fieldSysPath.set(null, null);
        StartMenu mainFrame = new StartMenu();
        mainFrame.setVisible(true);
    }
}

