/*
 * Decompiled with CFR 0.152.
 */
package com.centralnexus.thermal;

import com.centralnexus.thermal.Messages;
import com.lti.civil.CaptureDeviceInfo;
import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.CaptureSystem;
import com.lti.civil.CaptureSystemFactory;
import com.lti.civil.DefaultCaptureSystemFactorySingleton;
import com.lti.civil.awt.AWTImageConverter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class WebcamPanel
extends JComponent
implements Runnable,
CaptureObserver {
    private static final long serialVersionUID = 3132607519545989880L;
    private static CaptureSystem system;
    private CaptureStream captureStream;
    private static CaptureSystemFactory factory;
    private CaptureDeviceInfo captureInfo = null;
    private volatile boolean disposing = false;
    public static final int DEFAULT_WIDTH = 640;
    public static final int DEFAULT_HEIGHT = 480;
    private BufferedImage image = new BufferedImage(640, 480, 1);
    private Image scaledImage = this.image;

    public WebcamPanel() {
        this.initComponents();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.setMaximumSize(new Dimension(640, 480));
        this.setMinimumSize(new Dimension(640, 480));
        this.setPreferredSize(new Dimension(640, 480));
    }

    public synchronized void run(String deviceID) throws CaptureException {
        if (this.disposing || this.getDeviceID().equals(deviceID)) {
            this.disposing = false;
        } else {
            this.initCapture(deviceID);
            if (this.captureStream != null) {
                this.setSize(this.captureStream.getVideoFormat().getWidth(), this.captureStream.getVideoFormat().getHeight());
            }
            this.setVisible(true);
            this.startCapture();
        }
    }

    public void saveImage(String dirName) throws CaptureException {
        this.saveJPG(dirName);
    }

    public void initCapture(String devID) throws CaptureException {
        List<CaptureDeviceInfo> list = WebcamPanel.getCaptureList();
        if (list.size() > 0) {
            if (devID == null || devID.length() == 0) {
                this.captureInfo = list.get(0);
            } else {
                int i = 0;
                while (i < list.size()) {
                    CaptureDeviceInfo currInfo = list.get(i);
                    if (currInfo.getDeviceID().equals(devID)) {
                        this.captureInfo = currInfo;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (this.captureInfo != null) {
            System.out.println("Device ID: " + this.captureInfo.getDeviceID());
            System.out.println("Description: " + this.captureInfo.getDescription());
            this.captureStream = system.openCaptureDeviceStream(this.captureInfo.getDeviceID());
            this.captureStream.setObserver(this);
        } else {
            System.err.println("No video cameras present.");
        }
    }

    public static synchronized List<CaptureDeviceInfo> getCaptureList() {
        Vector<CaptureDeviceInfo> retList = new Vector<CaptureDeviceInfo>();
        try {
            if (factory == null) {
                factory = DefaultCaptureSystemFactorySingleton.instance();
            }
            if (system == null) {
                system = factory.createCaptureSystem();
            }
            system.init();
            List<CaptureDeviceInfo> list = system.getCaptureDeviceInfoList();
            int i = 0;
            while (i < list.size()) {
                CaptureDeviceInfo info = list.get(i);
                retList.add(info);
                ++i;
            }
        }
        catch (CaptureException e) {
            e.printStackTrace(System.err);
        }
        return retList;
    }

    public String getDeviceID() {
        return this.captureInfo != null ? this.captureInfo.getDeviceID() : "";
    }

    public void startCapture() throws CaptureException {
        if (this.captureStream != null) {
            try {
                this.captureStream.start();
            }
            catch (CaptureException e) {
                JOptionPane.showMessageDialog(null, Messages.getString("WebcamPanel.CameraNotConnected", new Object[0]), Messages.getString("Warning", new Object[0]), 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, Messages.getString("WebcamPanel.CameraNotConnected", new Object[0]), Messages.getString("Warning", new Object[0]), 2);
        }
    }

    public synchronized void stopCapture() throws CaptureException {
        this.disposing = true;
    }

    public synchronized void disposeCapture() throws CaptureException {
        this.disposing = true;
        if (this.captureStream != null) {
            this.captureStream.dispose();
            this.captureStream = null;
        }
        if (system != null) {
            system.dispose();
            system = null;
        }
        this.disposing = false;
    }

    @Override
    public void onError(CaptureStream sender, CaptureException e) {
        e.printStackTrace();
    }

    @Override
    public synchronized void onNewImage(CaptureStream sender, com.lti.civil.Image image) {
        if (this.disposing) {
            return;
        }
        try {
            this.setImage(AWTImageConverter.toBufferedImage(image));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public synchronized void setImage(BufferedImage image) {
        this.scaledImage = image.getWidth(this) != this.getWidth() || image.getHeight(this) != this.getHeight() ? image.getScaledInstance(this.getWidth(), this.getHeight(), 2) : image;
        this.image = image;
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        this.repaint();
    }

    @Override
    public synchronized void paint(Graphics g) {
        if (this.scaledImage != null) {
            g.drawImage(this.scaledImage, 0, 0, this);
            g.setColor(Color.yellow);
            g.fillOval(310, 230, 20, 20);
            g.fillOval(0, 470, 20, 20);
        }
    }

    public synchronized void saveJPG(String dirName) {
        try {
            ImageIO.write((RenderedImage)this.image, "jpg", new File(String.valueOf(dirName) + "/Webcam.jpg"));
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }
}

