/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vicovre.utils.nativeloader;

import com.googlecode.vicovre.utils.nativeloader.LoadException;
import com.googlecode.vicovre.utils.nativeloader.Loader;
import com.googlecode.vicovre.utils.nativeloader.ResourceLoader;
import com.googlecode.vicovre.utils.nativeloader.SameURLLoader;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeLoader {
    protected static final File USER_LIB_DIR = new File(System.getProperty("user.home"), ".native");
    private static final Loader[] LOADERS = new Loader[]{new SameURLLoader(), new ResourceLoader()};
    private static final Vector<String> PREFIXES = new Vector();
    private static final HashMap<String, Integer> LOADING;
    private static final HashMap<String, String> LOADERROR;

    private static void addOSParts(String prefix) {
        PREFIXES.add(prefix);
        String[] os = System.getProperty("os.name").split(" ");
        String version = System.getProperty("os.version");
        String osName = "";
        for (String part : os) {
            if (!osName.equals("")) {
                osName = osName + "/";
            }
            osName = osName + part.toLowerCase();
            PREFIXES.add(prefix + osName + "/");
        }
        osName = osName + "/" + version.toLowerCase() + "/";
        PREFIXES.add(prefix + osName);
    }

    private NativeLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibrary(Class<?> loadingClass, String name) {
        Integer sync = null;
        Serializable serializable = LOADING;
        synchronized (serializable) {
            sync = LOADING.get(name);
            if (sync == null) {
                sync = new Integer(0);
                LOADING.put(name, sync);
            }
        }
        serializable = sync;
        synchronized (serializable) {
            String loadError = LOADERROR.get(name);
            if (loadError != null) {
                if (loadError.equals("")) {
                    return;
                }
                throw new UnsatisfiedLinkError(loadError);
            }
            try {
                System.loadLibrary(name);
                return;
            }
            catch (UnsatisfiedLinkError e) {
                USER_LIB_DIR.mkdirs();
                String libraryName = System.mapLibraryName(name);
                for (Loader loader : LOADERS) {
                    for (String prefix : PREFIXES) {
                        try {
                            loader.load(loadingClass, prefix + libraryName);
                            LOADERROR.put(name, "");
                            return;
                        }
                        catch (UnsatisfiedLinkError error) {
                        }
                        catch (LoadException error) {
                            error.printStackTrace();
                            loadError = error.getMessage();
                        }
                    }
                }
                String error = "Could not find library " + name;
                if (loadError != null) {
                    error = error + ": " + loadError;
                }
                LOADERROR.put(name, error);
                throw new UnsatisfiedLinkError(error);
            }
        }
    }

    public static void main(String[] args) {
        System.err.println("Shared libraries can go into one of the following locations:");
        for (String prefix : PREFIXES) {
            System.err.println("    /" + prefix);
        }
    }

    static {
        String arch = System.getProperty("os.arch");
        NativeLoader.addOSParts("");
        NativeLoader.addOSParts("native/");
        NativeLoader.addOSParts(arch + "/");
        NativeLoader.addOSParts("native/" + arch.toLowerCase() + "/");
        LOADING = new HashMap();
        LOADERROR = new HashMap();
    }
}

