/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vicovre.utils.nativeloader;

import com.googlecode.vicovre.utils.nativeloader.LoadException;
import com.googlecode.vicovre.utils.nativeloader.Loader;
import com.googlecode.vicovre.utils.nativeloader.NativeLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SameURLLoader
implements Loader {
    private static final int BUFFER_SIZE = 1024;

    @Override
    public void load(Class<?> loadingClass, String name) throws LoadException {
        block7: {
            String pathToClass = "/" + loadingClass.getCanonicalName().replace(".", "/") + ".class";
            URL classUrl = loadingClass.getResource(pathToClass);
            if (classUrl.getProtocol().equals("jar")) {
                String url = classUrl.toString();
                String jarUrl = url.substring("jar".length() + 1, url.indexOf("!"));
                String dirUrl = jarUrl.substring(0, jarUrl.lastIndexOf("/"));
                try {
                    URL lib = new URL(dirUrl + "/" + name);
                    if (lib.getProtocol().equals("file")) {
                        File file = new File(lib.getFile());
                        if (file.exists()) {
                            System.load(file.getAbsolutePath());
                            return;
                        }
                        break block7;
                    }
                    URLConnection connection = lib.openConnection();
                    InputStream input = connection.getInputStream();
                    File file = new File(NativeLoader.USER_LIB_DIR, name);
                    if (!file.exists()) {
                        file.getParentFile().mkdirs();
                        FileOutputStream output = new FileOutputStream(file);
                        byte[] buffer = new byte[1024];
                        int bytesRead = input.read(buffer);
                        while (bytesRead != -1) {
                            output.write(buffer, 0, bytesRead);
                            bytesRead = input.read(buffer);
                        }
                        output.close();
                        input.close();
                    }
                    System.load(file.getAbsolutePath());
                    return;
                }
                catch (Throwable e) {
                    throw new LoadException(e);
                }
            }
        }
        throw new UnsatisfiedLinkError("Could not find " + name + " at same url as jar");
    }
}

