/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.awt;

import com.lti.civil.Image;
import com.lti.civil.VideoFormat;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class AWTImageConverter {
    public static BufferedImage toBufferedImage(Image image) {
        VideoFormat format = image.getFormat();
        int w = format.getWidth();
        int h = format.getHeight();
        if (format.getFormatType() == 1 && format.getDataType() == 1) {
            byte[] bytes = (byte[])image.getObject();
            DataBufferByte db = new DataBufferByte(new byte[][]{bytes}, bytes.length, new int[]{image.getOffset()});
            ComponentSampleModel sm = new ComponentSampleModel(0, w, h, 3, w * 3, new int[]{2, 1, 0});
            WritableRaster r = Raster.createWritableRaster(sm, db, new Point(0, 0));
            ColorSpace cs = ColorSpace.getInstance(1000);
            int[] nBits = new int[]{8, 8, 8};
            ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, false, false, 1, 0);
            BufferedImage bi = new BufferedImage(colorModel, r, false, null);
            return bi;
        }
        if (format.getFormatType() == 2 && format.getDataType() == 1) {
            byte[] bytes = (byte[])image.getObject();
            DataBufferByte db = new DataBufferByte(new byte[][]{bytes}, bytes.length, new int[]{image.getOffset()});
            ComponentSampleModel sm = new ComponentSampleModel(0, w, h, 4, w * 4, new int[]{2, 1, 0, 3});
            WritableRaster r = Raster.createWritableRaster(sm, db, new Point(0, 0));
            ColorSpace cs = ColorSpace.getInstance(1000);
            int[] nBits = new int[]{8, 8, 8, 8};
            ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, true, false, 3, 0);
            BufferedImage bi = new BufferedImage(colorModel, r, false, null);
            return bi;
        }
        if (format.getFormatType() == 2 && format.getDataType() == 4) {
            int[] data = (int[])image.getObject();
            DataBufferInt db = new DataBufferInt(data, w * h, image.getOffset());
            SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(3, w, h, new int[]{0xFF0000, 65280, 255});
            WritableRaster r = Raster.createWritableRaster(sm, db, new Point(0, 0));
            ColorSpace cs = ColorSpace.getInstance(1000);
            DirectColorModel colorModel = new DirectColorModel(cs, 24, 0xFF0000, 65280, 255, 0, false, 3);
            BufferedImage bi = new BufferedImage(colorModel, r, false, null);
            return bi;
        }
        throw new IllegalArgumentException("Unable to convert non-rgb video (" + format.getFormatType() + ") to AWT");
    }
}

