/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.impl.qtjava;

import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.VideoFormat;
import com.lti.civil.impl.common.BufferedImageImage;
import com.lti.civil.impl.common.VideoFormatImpl;
import com.lti.civil.utility.LoggerSingleton;
import com.lti.utils.synchronization.CloseableThread;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.image.CodecComponent;
import quicktime.std.image.DSequence;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.Matrix;
import quicktime.std.image.QTImage;
import quicktime.std.sg.SGChannel;
import quicktime.std.sg.SGDataProc;
import quicktime.std.sg.SGVideoChannel;
import quicktime.std.sg.SequenceGrabber;
import quicktime.util.EncodedImage;
import quicktime.util.QTPointerRef;
import quicktime.util.RawEncodedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QTCaptureStream
implements CaptureStream {
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean ALLOC_NEW_IMAGE_EACH_FRAME = true;
    private GrabberThread thread;
    private CaptureObserver observer;
    private final boolean bigEndian = System.getProperty("sun.cpu.endian").equals("big");
    private int frameCount = 0;
    private SequenceGrabber sg;
    private QDRect cameraImageSize;
    private QDGraphics gWorld;
    private byte[] pixelData;
    private BufferedImage image;
    private SGVideoChannel vc;
    private int myCodec;
    private boolean sequenceGrabberInitialized;
    private boolean stopping;
    private boolean started;
    private List<VideoFormat> videoFormats;
    private VideoFormat overrideVideoFormat;

    public QTCaptureStream() throws QTException {
        logger.info("Big endian: " + this.bigEndian);
        this.initSequenceGrabber();
        this.enumVideoFormats();
    }

    private void initSequenceGrabber() throws QTException {
        if (this.sequenceGrabberInitialized) {
            return;
        }
        QTSession.open();
        this.sg = new SequenceGrabber();
        QTException exception = null;
        int RETRIES = 5;
        int RETRY_INTERVAL_MS = 200;
        for (int i = 0; i < 5; ++i) {
            try {
                this.vc = new SGVideoChannel(this.sg);
                break;
            }
            catch (QTException ex) {
                logger.info("Failed to initialize Video Channel" + (i < 4 ? ", trying again" : ""));
                exception = ex;
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "" + e, e);
                    return;
                }
            }
        }
        if (this.vc == null) {
            throw exception;
        }
        if (this.overrideVideoFormat != null) {
            this.cameraImageSize = new QDRect(this.overrideVideoFormat.getWidth(), this.overrideVideoFormat.getHeight());
        } else {
            this.cameraImageSize = this.vc.getSrcVideoBounds();
            logger.info("Camera image size reported as: " + this.cameraImageSize.getWidth() + "x" + this.cameraImageSize.getHeight());
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            if (this.cameraImageSize.getHeight() > screen.height - 40) {
                logger.warning("Camera image size reported as: " + this.cameraImageSize.getWidth() + "x" + this.cameraImageSize.getHeight() + "; resizing to 640x480");
                this.cameraImageSize.resize(640, 480);
            }
        }
        this.gWorld = new QDGraphics(this.bigEndian ? 32 : 1094862674, this.cameraImageSize);
        this.sg.setGWorld(this.gWorld, null);
        this.vc.setBounds(this.cameraImageSize);
        this.vc.setUsage(1);
        this.vc.setFrameRate(0.0f);
        this.myCodec = 2037741106;
        this.vc.setCompressorType(this.myCodec);
        this.sequenceGrabberInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeSequenceGrabber() throws QTException {
        if (!this.sequenceGrabberInitialized) {
            return;
        }
        try {
            if (this.vc != null) {
                this.vc.disposeQTObject();
            }
            if (this.sg != null) {
                this.sg.stop();
                this.sg.disposeQTObject();
            }
            QTSession.close();
        }
        finally {
            this.sequenceGrabberInitialized = false;
        }
    }

    private void initBufferedImage() {
        this.pixelData = this.allocPixelData();
        this.image = this.allocBufferedImage(this.pixelData);
    }

    private byte[] allocPixelData() {
        int intsPerRow = this.gWorld.getPixMap().getPixelData().getRowBytes() / 4;
        int size = intsPerRow * this.cameraImageSize.getHeight();
        return new byte[size * 4];
    }

    private BufferedImage allocBufferedImage(byte[] bytes) {
        int[] nArray;
        int bytesPerRow = this.gWorld.getPixMap().getPixelData().getRowBytes();
        int w = this.cameraImageSize.getWidth();
        int h = this.cameraImageSize.getHeight();
        DataBufferByte db = new DataBufferByte(new byte[][]{bytes}, bytes.length);
        if (this.bigEndian) {
            int[] nArray2 = new int[4];
            nArray2[0] = 1;
            nArray2[1] = 2;
            nArray2[2] = 3;
            nArray = nArray2;
            nArray2[3] = 0;
        } else {
            int[] nArray3 = new int[4];
            nArray3[0] = 3;
            nArray3[1] = 2;
            nArray3[2] = 1;
            nArray = nArray3;
            nArray3[3] = 0;
        }
        ComponentSampleModel sm = new ComponentSampleModel(0, w, h, 4, bytesPerRow, nArray);
        WritableRaster r = Raster.createWritableRaster(sm, db, new Point(0, 0));
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8, 8};
        ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, true, false, 3, 0);
        return new BufferedImage(colorModel, r, false, null);
    }

    private void startPreviewing() throws QTException {
        SGDataProc myDataProc = new SGDataProc(){
            DSequence ds = null;
            final Matrix idMatrix = new Matrix();
            byte[] rawData = new byte[QTImage.getMaxCompressionSize((QDGraphics)QTCaptureStream.access$000(QTCaptureStream.this), (QDRect)QTCaptureStream.access$000(QTCaptureStream.this).getBounds(), (int)0, (int)256, (int)QTCaptureStream.access$100(QTCaptureStream.this), (CodecComponent)CodecComponent.anyCodec)];
            RawEncodedImage ri = null;

            public int execute(SGChannel chan, QTPointerRef dataToWrite, int offset, int chRefCon, int time, int writeType) {
                if (chan instanceof SGVideoChannel) {
                    try {
                        if (!QTCaptureStream.this.sequenceGrabberInitialized || !QTCaptureStream.this.started || QTCaptureStream.this.stopping) {
                            return 0;
                        }
                        long timestamp = System.currentTimeMillis();
                        ImageDescription id = QTCaptureStream.this.vc.getImageDescription();
                        if (this.rawData == null) {
                            this.rawData = new byte[dataToWrite.getSize()];
                        }
                        RawEncodedImage ri = new RawEncodedImage(this.rawData);
                        dataToWrite.copyToArray(0, this.rawData, 0, dataToWrite.getSize());
                        if (this.ds == null) {
                            this.ds = new DSequence(id, (EncodedImage)ri, QTCaptureStream.this.gWorld, QTCaptureStream.this.cameraImageSize, this.idMatrix, null, 0, 512, CodecComponent.anyCodec);
                        } else {
                            this.ds.decompressFrameS(ri, 512);
                        }
                        QTCaptureStream.this.initBufferedImage();
                        QTCaptureStream.this.gWorld.getPixMap().getPixelData().copyToArray(0, QTCaptureStream.this.pixelData, 0, QTCaptureStream.this.pixelData.length);
                        if (QTCaptureStream.this.observer != null) {
                            QTCaptureStream.this.observer.onNewImage(QTCaptureStream.this, new BufferedImageImage(QTCaptureStream.this.image, timestamp));
                        }
                        return 0;
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, "" + ex, ex);
                        return 1;
                    }
                }
                return 1;
            }
        };
        this.sg.setDataProc(myDataProc);
        this.sg.setDataOutput(null, 32);
        this.sg.prepare(false, true);
        this.sg.startRecord();
    }

    @Override
    public List<VideoFormat> enumVideoFormats() {
        if (this.videoFormats != null) {
            return this.videoFormats;
        }
        this.videoFormats = new ArrayList<VideoFormat>();
        this.videoFormats.add(new VideoFormatImpl(2, this.cameraImageSize.getWidth(), this.cameraImageSize.getHeight(), -1.0f, 1));
        this.videoFormats.add(new VideoFormatImpl(2, this.cameraImageSize.getWidth() / 2, this.cameraImageSize.getHeight() / 2, -1.0f, 1));
        return this.videoFormats;
    }

    @Override
    public void setVideoFormat(VideoFormat f) throws CaptureException {
        this.overrideVideoFormat = f;
    }

    @Override
    public VideoFormat getVideoFormat() throws CaptureException {
        if (this.overrideVideoFormat != null) {
            return this.overrideVideoFormat;
        }
        return this.enumVideoFormats().get(0);
    }

    @Override
    public void setObserver(CaptureObserver observer, int numBuffersHint) {
        this.observer = observer;
    }

    @Override
    public void setObserver(CaptureObserver observer) {
        this.setObserver(observer, 2);
    }

    @Override
    public void start() throws CaptureException {
        if (this.started) {
            return;
        }
        if (this.thread != null) {
            logger.log(Level.WARNING, "QTCaptureStream already started, start called without stop, ignoring");
            return;
        }
        try {
            this.initSequenceGrabber();
            this.initBufferedImage();
            this.startPreviewing();
        }
        catch (QTException e) {
            throw new CaptureException(e);
        }
        if (this.thread == null) {
            this.thread = new GrabberThread();
            this.thread.start();
        }
        this.started = true;
    }

    @Override
    public void stop() throws CaptureException {
        if (!this.started) {
            return;
        }
        this.stopping = true;
        if (this.thread != null) {
            this.thread.close();
        }
        if (this.thread != null) {
            try {
                logger.fine("Waiting for GrabberThread to complete...");
                this.thread.waitUntilClosed();
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "" + e, e);
                return;
            }
        }
        logger.fine("GrabberThread completed");
        this.thread = null;
        try {
            this.disposeSequenceGrabber();
        }
        catch (QTException e) {
            throw new CaptureException(e);
        }
        this.started = false;
        this.stopping = false;
    }

    @Override
    public void dispose() throws CaptureException {
        this.stop();
    }

    static /* synthetic */ int access$100(QTCaptureStream x0) {
        return x0.myCodec;
    }

    class GrabberThread
    extends CloseableThread {
        private final int taskingDelay = 25;

        public GrabberThread() {
            super(Thread.currentThread().getThreadGroup(), "GrabberThread");
            this.taskingDelay = 25;
            this.setDaemon(true);
        }

        public void close() {
            this.setClosing();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                QTSession.open();
                while (!this.isClosing()) {
                    Thread.sleep(25L);
                    QTCaptureStream.this.sg.idleMore();
                    QTCaptureStream.this.sg.update(null);
                }
            }
            catch (InterruptedException ex) {
            }
            catch (Exception ex) {
                if (QTCaptureStream.this.observer != null && !this.isClosing()) {
                    QTCaptureStream.this.observer.onError(QTCaptureStream.this, new CaptureException(ex));
                }
            }
            finally {
                QTSession.close();
                this.setClosed();
            }
        }
    }
}

