/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.swing;

import com.lti.civil.CaptureDeviceInfo;
import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.CaptureSystem;
import com.lti.civil.CaptureSystemFactory;
import com.lti.civil.DefaultCaptureSystemFactorySingleton;
import com.lti.civil.Image;
import com.lti.civil.VideoFormat;
import com.lti.civil.awt.AWTImageConverter;
import com.lti.civil.swing.CaptureDevice;
import com.lti.civil.swing.ImageFrame;
import com.lti.civil.utility.LoggerSingleton;
import com.lti.civil.utility.VideoFormatNames;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class CaptureFrame
extends ImageFrame {
    private static final Logger logger = LoggerSingleton.logger;
    private CaptureSystem system;
    private CaptureStream captureStream;
    private final CaptureSystemFactory factory;
    private volatile boolean disposing = false;

    public static void main(String[] args) throws CaptureException {
        new CaptureFrame(DefaultCaptureSystemFactorySingleton.instance()).run();
    }

    public CaptureFrame(CaptureSystemFactory factory) {
        super("LTI-CIVIL");
        this.factory = factory;
    }

    public void run() throws CaptureException {
        this.initCapture();
        if (this.captureStream == null) {
            System.exit(0);
        }
        this.setSize(this.captureStream.getVideoFormat().getWidth(), this.captureStream.getVideoFormat().getHeight());
        this.setLocation(200, 200);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                try {
                    CaptureFrame.this.disposeCapture();
                }
                catch (CaptureException e1) {
                    logger.log(Level.SEVERE, "" + e1, e1);
                }
                System.exit(0);
            }
        });
        this.setVisible(true);
        this.pack();
        this.startCapture();
    }

    public void initCapture() throws CaptureException {
        Object[] inputs;
        CaptureDeviceInfo info;
        this.system = this.factory.createCaptureSystem();
        this.system.init();
        List<CaptureDeviceInfo> list = this.system.getCaptureDeviceInfoList();
        Vector<CaptureDevice> choices = new Vector<CaptureDevice>();
        for (int i = 0; i < list.size(); ++i) {
            info = list.get(i);
            String[] outputs = info.getOutputNames();
            if (outputs.length <= 1) {
                choices.add(new CaptureDevice(info));
                continue;
            }
            for (int j = 0; j < outputs.length; ++j) {
                choices.add(new CaptureDevice(info, j));
            }
        }
        CaptureDevice device = (CaptureDevice)JOptionPane.showInputDialog(null, "Select Capture Device:", "Capture Device", 3, null, choices.toArray(), choices.get(0));
        if (device == null) {
            System.exit(0);
        }
        info = device.getInfo();
        int output = device.getOutput();
        int input = 0;
        if (info.getOutputNames().length >= 1 && (inputs = info.getInputNames(output)).length > 0) {
            String inputName = (String)JOptionPane.showInputDialog(null, "Select Input:", "Input", 3, null, inputs, null);
            if (inputName == null) {
                System.exit(0);
            }
            for (int i = 0; i < inputs.length; ++i) {
                if (!((String)inputs[i]).equals(inputName)) continue;
                input = i;
                break;
            }
        }
        System.err.println(info.getDeviceID());
        logger.fine("Device ID: " + info.getDeviceID());
        logger.fine("Description: " + info.getDescription());
        this.captureStream = this.system.openCaptureDeviceStreamOutput(info.getDeviceID(), output, input);
        List<VideoFormat> formats = this.captureStream.enumVideoFormats();
        VideoFormat def = this.captureStream.getVideoFormat();
        Object[] formatChoices = new Format[formats.size()];
        Object defaultFormat = null;
        for (int j = 0; j < formats.size(); ++j) {
            VideoFormat format = formats.get(j);
            formatChoices[j] = new Format(format);
            if (!format.equals(def)) continue;
            defaultFormat = formatChoices[j];
        }
        Format format = (Format)JOptionPane.showInputDialog(null, "Select Format:", "Format", 3, null, formatChoices, defaultFormat);
        if (format == null) {
            System.exit(0);
        }
        this.captureStream.setVideoFormat(format.format);
        this.captureStream.setObserver(new MyCaptureObserver(), 10);
        this.captureStream.start();
    }

    public void startCapture() throws CaptureException {
        this.captureStream.start();
    }

    public void disposeCapture() throws CaptureException {
        this.disposing = true;
        if (this.captureStream != null) {
            logger.fine("disposeCapture: stopping capture stream...");
            this.captureStream.stop();
            logger.fine("disposeCapture: stopped capture stream.");
            this.captureStream.dispose();
            this.captureStream = null;
        }
        if (this.system != null) {
            this.system.dispose();
        }
        logger.fine("disposeCapture done.");
    }

    class MyCaptureObserver
    implements CaptureObserver {
        MyCaptureObserver() {
        }

        public void onError(CaptureStream sender, CaptureException e) {
            logger.log(Level.WARNING, "onError " + sender + ": " + e, e);
        }

        public void onNewImage(CaptureStream sender, Image image) {
            if (CaptureFrame.this.disposing) {
                return;
            }
            try {
                CaptureFrame.this.setImage(AWTImageConverter.toBufferedImage(image));
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "" + t, t);
            }
        }
    }

    private class Format {
        private VideoFormat format = null;

        private Format(VideoFormat format) {
            this.format = format;
        }

        public String toString() {
            return this.format.getWidth() + " x " + this.format.getHeight() + " (" + VideoFormatNames.formatTypeToString(this.format.getFormatType()) + ")";
        }
    }
}

