/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.VolatileImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ImageFrame
extends JFrame {
    private ImageComponent ic = new ImageComponent();

    public void setImage(Image image) {
        this.ic.setImage(image);
    }

    public ImageFrame(String title) {
        super(title);
        this.getContentPane().add(this.ic);
    }

    public void setImageSize(int h, int w) {
        this.ic.setImageSize(new Dimension(h, w));
    }

    public class ImageComponent
    extends JComponent {
        private Image image;
        private VolatileImage vImage;
        private Dimension size = new Dimension(0, 0);

        public void setImage(Image image) {
            SwingUtilities.invokeLater(new ImageRunnable(image));
        }

        public void setImageSize(Dimension newSize) {
            if (!newSize.equals(this.size)) {
                this.size = newSize;
                this.setSize(this.size);
                ImageFrame.this.pack();
            }
        }

        private synchronized void setImageInSwingThread(Image image) {
            this.image = image;
            Dimension newSize = new Dimension(image.getWidth(null), image.getHeight(null));
            this.setImageSize(newSize);
            this.repaint();
        }

        public ImageComponent() {
            this.setSize(this.size);
        }

        public synchronized void paint(Graphics g) {
            if (this.image != null) {
                do {
                    if (this.vImage == null) {
                        this.vImage = this.createVolatileImage(this.image.getWidth(this), this.image.getHeight(this));
                    }
                    Graphics graphics = this.vImage.getGraphics();
                    graphics.drawImage(this.image, 0, 0, this);
                } while (this.vImage.contentsLost());
                g.drawImage(this.vImage, 0, 0, this.getWidth(), this.getHeight(), 0, 0, this.image.getWidth(this), this.image.getHeight(this), this);
            }
        }

        public synchronized Dimension getPreferredSize() {
            return this.size;
        }

        private class ImageRunnable
        implements Runnable {
            private final Image newImage;

            public ImageRunnable(Image newImage) {
                this.newImage = newImage;
            }

            public void run() {
                ImageComponent.this.setImageInSwingThread(this.newImage);
            }
        }
    }
}

