/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.webcam;

import com.lti.civil.CaptureDeviceInfo;
import com.lti.civil.CaptureStream;
import com.lti.civil.CaptureSystem;
import com.lti.civil.CaptureSystemFactory;
import com.lti.civil.DefaultCaptureSystemFactorySingleton;
import com.lti.civil.utility.LoggerSingleton;
import com.lti.civil.webcam.CivilJPEG_HTTPD;
import com.lti.civil.webcam.StoreMostRecent_CaptureObserver;
import java.util.List;
import java.util.logging.Logger;

public class CivilJPEGServer {
    private static final Logger logger = LoggerSingleton.logger;

    public static void main(String[] args) throws Exception {
        CaptureSystemFactory factory = DefaultCaptureSystemFactorySingleton.instance();
        CaptureSystem system = factory.createCaptureSystem();
        system.init();
        List<CaptureDeviceInfo> list = system.getCaptureDeviceInfoList();
        int i = 0;
        if (i < list.size()) {
            CaptureDeviceInfo info = list.get(i);
            logger.info("Device ID " + i + ": " + info.getDeviceID());
            logger.info("Description " + i + ": " + info.getDescription());
            CaptureStream captureStream = system.openCaptureDeviceStream(info.getDeviceID());
            CivilJPEG_HTTPD.storeMostRecent_CaptureObserver = new StoreMostRecent_CaptureObserver();
            captureStream.setObserver(CivilJPEG_HTTPD.storeMostRecent_CaptureObserver, 2);
            captureStream.start();
        }
        logger.info("Starting CIVIL web server on port 8090...");
        new CivilJPEG_HTTPD(8090);
        while (true) {
            Thread.sleep(10000L);
        }
    }
}

