/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.webcam;

import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.Image;
import com.lti.civil.awt.AWTImageConverter;
import com.lti.civil.utility.LoggerSingleton;
import com.lti.utils.synchronization.SynchronizedObjectHolder;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class StoreMostRecent_CaptureObserver
implements CaptureObserver {
    private static final Logger logger = LoggerSingleton.logger;
    private SynchronizedObjectHolder<byte[]> bytes = new SynchronizedObjectHolder();

    public void onNewImage(CaptureStream sender, Image image) {
        if (image == null) {
            this.bytes = null;
            return;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)AWTImageConverter.toBufferedImage(image), "JPG", os);
            os.close();
            this.bytes.setObject(os.toByteArray());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            this.bytes.setObject(null);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "" + t, t);
            this.bytes.setObject(null);
        }
    }

    public void onError(CaptureStream sender, CaptureException e) {
        logger.log(Level.WARNING, "" + e, e);
        this.bytes.setObject(null);
    }

    public byte[] getBytes() {
        return this.bytes.getObject();
    }
}

